/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.client.render;

import com.flemmli97.tenshilib.api.entity.IBeamEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RenderBeam<T extends Entity>
extends EntityRenderer<T> {
    protected final float radius;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;

    public RenderBeam(EntityRendererManager manager, float width) {
        super(manager);
        this.radius = width;
    }

    public void setColor(int hexColor) {
        this.setColorAndAlpha(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF, hexColor >> 24 & 0xFF);
    }

    public void setColor(int red, int green, int blue) {
        this.red = red;
        this.blue = blue;
        this.green = green;
    }

    public void setColorAndAlpha(int red, int green, int blue, int alpha) {
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.alpha = alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void func_225623_a_(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        ((IBeamEntity)entity).updateYawPitch();
        double dist = ((IBeamEntity)entity).hitVec().func_72438_d(((IBeamEntity)entity).startVec());
        double width = this.widthFunc(entity);
        matrixStack.func_227860_a_();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
    }

    public abstract Pair<ResourceLocation, Float> startTexture(T var1);

    public abstract Pair<ResourceLocation, Float> endTexture(T var1);

    public double widthFunc(T entity) {
        return (double)this.radius * Math.sin(Math.sqrt((float)((Entity)entity).field_70173_aa / (float)((IBeamEntity)entity).livingTickMax()) * Math.PI);
    }

    public double segmentLength() {
        return 0.0;
    }

    public int animationFrames(BeamPart part) {
        return 1;
    }

    public int currentAnimation(T entity, BeamPart part) {
        return ((Entity)entity).field_70173_aa % this.animationFrames(part) + 1;
    }

    private double[] split(double length) {
        int arrL = (int)Math.ceil(length / this.segmentLength());
        double[] arr = new double[arrL];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Math.max(0.0, length - (double)i * this.segmentLength());
        }
        return arr;
    }

    public static enum BeamPart {
        START,
        END,
        MIDDLE;

    }
}

